﻿//////////////////////////////////////////////
// ScriptObjectInterpreterReference.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkScripts
#include "../Functions/FunctionParameterType.h"

/// Class ------------------------------------

namespace nkScripts
{
	class ScriptObjectInterpreterReference
	{
		public :

			// Functions
			// Constructor, destructor
			ScriptObjectInterpreterReference (FUNCTION_PARAMETER_TYPE type)
			:	_type (type)
			{
				// Nothing to do
			}

			virtual ~ScriptObjectInterpreterReference () = default ;

			// Getters
			FUNCTION_PARAMETER_TYPE getType () const
			{
				return _type ;
			}

		protected :

			// Attributes
			// Type of data
			FUNCTION_PARAMETER_TYPE _type = FUNCTION_PARAMETER_TYPE::VOID ;
	} ;
}